$PROBLEM PK. Tests of modifications to column names in $INPUT

;; One variable is dropped, BBW is a new name.         
;| Variables 15/20 |;
$INPUT ROW ID TIME EVID CMT AMT DV MDV BBW

$DATA ./NMsimData_xgxr025_subprobs.csv
IGN=@

$SUBROUTINE ADVAN4 TRANS4

$PK
KA=THETA(1)*EXP(ETA(1))
V2=THETA(2)*(BBW/75)*EXP(ETA(2))
CL=THETA(3)*EXP(ETA(3))
V3=THETA(4)*EXP(ETA(4))
Q=THETA(5)*EXP(ETA(5))

$ERROR
  IPRED=F
  IRES=DV-IPRED

  IF (IPRED.GT.1) THEN
    W = SQRT(IPRED**2*SIGMA(1,1)**2 + SIGMA(2,2)**2)
  ELSE
    W=1
  ENDIF

  IWRES=IRES/W
  Y=F+F*ERR(1)+ERR(2)

;-----------------------INITIAL ESTIMATES---------------------------------
$THETA
0.118755 FIX
0.0424054 FIX
0.842466 FIX
0.156963 FIX
571524000 FIX

$OMEGA 0.108086
$OMEGA 0 FIX
$OMEGA 0 FIX
$OMEGA 0 FIX
$OMEGA 0 FIX

$SIGMA 0.22259
$SIGMA 0.000685585



$SIMULATION ONLYSIM SUBPROBLEMS=4 (1458358178)

$TABLE ROW KA V3 Q NOHEADER FIRSTONLY FILE=NMsim_xgxr025_subprobs_1.tab 
$TABLE ROW KA V2 CL ONEHEADER FIRSTONLY FILE=NMsim_xgxr025_subprobs_2.tab
$TABLE ROW ID DV PRED IPRED FILE=NMsim_xgxr025_subprobs_3.tab 

