#' Print Method for the Output of the Fitting Method
#'
#' Method for printing the output of the fitting method. Gives fundamental
#' infofmation about the object.
#'
#' @param x An object of class \code{fitStMoMo_list}.
#' @param ... Further arguments passed to or from other methods.
#'
#' @return Prints basic information about the \code{fitStMoMo_list} object to
#' the console.
#'
#' @export
print.fitStMoMo_list <- function(x, ...) {
  cat("fitStMoMo_list object: a list of 'fitNNMoMo' / 'fitStMoMo' objects\n")
  cat(
    "Contains", x$NN_fittingModel$loss_type, "neural network models of type",
    x$NN_fittingModel$model_type, "with", x$NN_fittingModel$activation,
    "activation\n"
  )
}
