% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_cond_data.R
\docType{data}
\name{multi_cond_data}
\alias{multi_cond_data}
\title{Example dataset from a multi-condition qPCR experiment.}
\format{
A data frame structured with biological replicates in rows, replicate identifiers in a single column, stroke diagnoses in a single column, and raw CT values for each of the 12 target genes in the remaining columns.
}
\description{
A real-world qRT-PCR dataset containing raw CT values for 12 genes measured in whole blood total RNA originating from 29 human subjects diagnosed with ischemic stroke and 33 neurologically normal controls, as described in O’Connell et al. (2017).
}
\details{
This dataset is suitable for demonstrating or evaluating normalization workflows for use-cases involving data from multiple experimental conditions.
}
\examples{
#load example dataset

data(multi_cond_data)

#return dataset structure

str(multi_cond_data)

}
\references{
O'Connell, GC., Treadway, MB., Petrone, AB., Tennant, CS., Lucke-Wold, N, Chantler, PD., & Barr, TL. (2017).
Leukocyte dynamics influence reference gene stability in whole blood: Data-driven qRT-PCR normalization is a robust alternative for measurement of transcriptional biomarkers.
\emph{Laboratory Medicine}, 3, 48.
\doi{10.1093/labmed/lmx035}
}
