% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_rsi.R
\name{compute_rsi}
\alias{compute_rsi}
\title{Compute Rank-based Stability Index (RSI)}
\usage{
compute_rsi(data, y, gen, env, rep = NULL)
}
\arguments{
\item{data}{A data frame with genotype, environment, and response columns.}

\item{y}{Response variable column.}

\item{gen}{Genotype column.}

\item{env}{Environment column.}

\item{rep}{Optional replication column.}
}
\value{
A table containing RSI values for each genotype.
}
\description{
Compute Rank-based Stability Index (RSI)
}
\examples{
library(NPStability)
library(dplyr)
data(example_data)
rsi_results <- compute_rsi(example_data, Yield, Gen, Env)
rsi_biplot <- rsi_biplot(example_data, Yield, Gen, Env, rsi_table = rsi_results)
}
\references{
1. Kumar, P., Paul, A. K., Paul, R. K., Raju, B., Rathod, S., Ray, M., ... & Yeasin, M. (2024).
   A robust non-parametric stability measure to select stable genotypes.
   *The Indian Journal of Agricultural Sciences*, 94(9), 1007–1012.
2. Pour-Aboughadareh, A., Khalili, M., Poczai, P., & Olivoto, T. (2022).
   Stability Indices to Deciphering the Genotype-by-Environment Interaction (GEI) Effect:
   An Applicable Review for Use in Plant Breeding Programs. *Plants*, 11(3), 414.
}
