#' Calculate N Balance Intensity (NBI)
#' @description
#' The difference between fertilizer N applied and the N removed as yield (N Surplus).
#' Formula: NBI = FertN - YieldN
#' @param YieldN A numeric vector of the N removed as yield.
#' @param FertN A numeric value or vector for fertilizer N input.
#' @return A numeric vector of NBI values.
#' @examples
#' YieldN <- c(80, 90, 100)
#' FertN <- 50
#' NBI(YieldN, FertN)
#' @export
NBI <- function(YieldN, FertN) {
  return(FertN - YieldN)
}