% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecological_indices.R
\name{cal.TD}
\alias{cal.TD}
\alias{cal.TD.data.frame}
\alias{cal.TD.matrix}
\alias{cal.TD.default}
\title{Calculate Trophic Diversity (TD) Index}
\usage{
cal.TD(data, ...)

\method{cal.TD}{data.frame}(data, ...)

\method{cal.TD}{matrix}(data, ...)

\method{cal.TD}{default}(data, ...)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix}. The nematode abundance table where rows represent samples and columns represent nematode genera.
Each element indicates the count of a specific nematode genus in the corresponding sample. Row names must be sample names, and column names must be nematode genus names.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A data frame with two columns:
\item{Sample.ID}{Character vector of sample identifiers (from row names of \code{data})}
\item{TD}{Trophic Diversity index for each sample}
}
\description{
This function calculates the Trophic Diversity (TD) Index for ecological communities.
}
\examples{
# Example with a data frame
df <- data.frame(
  Cephalobus = c(10, NA, 15),
  Caenorhabditis = c(5, 10, NA),
  Pratylenchus = c(8, 12, 10),
  row.names = c("A", "B", "C")
)
cal.TD(data = df)
}
