% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_genus_match.R
\name{fuzzy_genus_match}
\alias{fuzzy_genus_match}
\title{Fuzzy Matching of Nematode Genus Names}
\usage{
fuzzy_genus_match(Query.genus, max_dist = 2, ...)
}
\arguments{
\item{Query.genus}{A \code{character vector} of genus names to be matched against the reference}

\item{max_dist}{Maximum allowed Levenshtein distance for matches (default = 2)}

\item{...}{Additional parameters (currently unused)}
}
\value{
A data frame containing:
\itemize{
\item Query.genus - Original query genus name
\item CorrectName - Matched genus name from reference
\item Distance - Edit distance between query and match
\item Additional columns - All columns from nematode.info for matched records
}
}
\description{
This function performs fuzzy matching of nematode genus names against a reference database
using Levenshtein distance (edit distance) with case insensitivity.
}
\examples{
fuzzy_genus_match(c("Harterta", "Meloidogyne"))

}
