#' Print Method for \code{gofic} Objects
#'
#' Nicely formats and prints the results produced by \code{gofic()}.
#'
#' @param x An object of class \code{"gofic"} as returned by \code{gofic()}.
#' @param ... Further arguments (currently unused).
#'
#' @return
#' The input object \code{x}, returned invisibly.
#' No value is returned for computational purposes; used for side effects.
#'
#' @seealso \code{\link{gofic}}
#'
#' @export

print.gofic <- function(x, ...) {
  cat("\n", strrep("-", 50), "\n")
  cat("                 Model Diagnostics\n")
  cat(strrep("-", 50), "\n")
  cat(sprintf("Log-likelihood : %10.4f\n", x$logLik))
  cat(sprintf("AIC            : %10.4f\n", x$AIC))
  cat(sprintf("BIC            : %10.4f\n", x$BIC))
  cat(sprintf("AICC           : %10.4f\n", x$AICC))
  cat(sprintf("HQIC           : %10.4f\n", x$HQIC))
  cat(strrep("-", 50), "\n")
  cat("            Goodness-of-Fit Tests\n")
  cat(strrep("-", 50), "\n")
  cat(sprintf("KS   : %8.4f (p = %.4f)\n",
              x$KS$statistic, x$KS$p.value))
  cat(sprintf("CVM  : %8.4f (p = %.4f)\n",
              x$CVM$statistic, x$CVM$p.value))
  cat(sprintf("AD   : %8.4f (p = %.4f)\n",
              x$AD$statistic, x$AD$p.value))
  cat(strrep("-", 50), "\n\n")
  invisible(x)
}
