% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCInvNHE.r
\name{HCInvNHE}
\alias{HCInvNHE}
\alias{dhc.inv.NHE}
\alias{phc.inv.NHE}
\alias{qhc.inv.NHE}
\alias{rhc.inv.NHE}
\alias{hhc.inv.NHE}
\title{Half-Cauchy Inverse NHE Distribution}
\usage{
dhc.inv.NHE(x, beta, lambda, theta, log = FALSE)
phc.inv.NHE(q, beta, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qhc.inv.NHE(p, beta, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rhc.inv.NHE(n, beta, lambda, theta)
hhc.inv.NHE(x, beta, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dhc.inv.NHE}: numeric vector of (log-)densities
  \item \code{phc.inv.NHE}: numeric vector of probabilities
  \item \code{qhc.inv.NHE}: numeric vector of quantiles
  \item \code{rhc.inv.NHE}: numeric vector of random variates
  \item \code{hhc.inv.NHE}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Half-Cauchy Inverse NHE distribution.
}
\details{
The Half-Cauchy Inverse NHE distribution is parameterized by the parameters
\eqn{\beta > 0}, \eqn{\lambda > 0}, and \eqn{\theta > 0}.


The Half-Cauchy Inverse NHE distribution has CDF:

\deqn{
F(x; \beta, \lambda, \theta) =
\quad 1 - \frac{2}{\pi }\arctan \left[ { - \frac{1}{\theta }\left\{ {1 - {{\left( 
{1 + \frac{\lambda }{x}} \right)}^\beta }} \right\}} \right] \quad ;\;x > 0.
}

where \eqn{\beta}, \eqn{\lambda}, and \eqn{\theta} are the parameters.

Included functions are:
\itemize{
  \item \code{dhc.inv.NHE()} — Density function
  \item \code{phc.inv.NHE()} — Distribution function
  \item \code{qhc.inv.NHE()} — Quantile function
  \item \code{rhc.inv.NHE()} — Random generation
  \item \code{hhc.inv.NHE()} — Hazard function
}
}
\examples{
x <- seq(1.0, 5, 0.25)
dhc.inv.NHE(x, 2.0, 0.5, 2.5)
phc.inv.NHE(x, 2.0, 0.5, 2.5)
qhc.inv.NHE(0.5, 2.0, 0.5, 2.5)
rhc.inv.NHE(10, 2.0, 0.5, 2.5)
hhc.inv.NHE(x, 2.0, 0.5, 2.5)

# Data
x <- relief
# ML estimates
params = list(beta=79.7799, lambda=0.1129, theta=154.1769)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = phc.inv.NHE, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qhc.inv.NHE, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
res <- gofic(x, params = params,
             dfun = dhc.inv.NHE, pfun=phc.inv.NHE, plot=FALSE)
print.gofic(res)

}
\references{
Chaudhary, A.K., Telee, L.B.S. & Kumar,V. (2022). 
Half-Cauchy Inverse NHE Distribution: Properties and Applications.
\emph{ Nepal Journal of Mathematical Sciences (NJMS)}, \bold{3(2)}, 
1--12.  \doi{10.3126/njmathsci.v3i2.49198}

Chaudhary, A. K., Sapkota, L. P., & Kumar, V. (2022). 
Some properties and applications of half Cauchy extended exponential 
distribution.\emph{ Int. J. Stat. Appl. Math.}, \bold{7(4)}, 226--235. 
\doi{10.22271/maths.2022.v7.i4c.866}

Chaudhary, A.K., & Kumar, V. (2022). 
Half Cauchy-Modified Exponential Distribution: Properties and Applications. 
\emph{ Nepal Journal of Mathematical Sciences (NJMS)}, \bold{3(1)}, 
47--58. \doi{10.3126/njmathsci.v3i1.44125}
}
