% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCNHE.r
\name{HCNHE}
\alias{HCNHE}
\alias{dhc.NHE}
\alias{phc.NHE}
\alias{qhc.NHE}
\alias{rhc.NHE}
\alias{hhc.NHE}
\title{Half-Cauchy NHE Distribution}
\usage{
dhc.NHE(x, beta, lambda, theta, log = FALSE)
phc.NHE(q, beta, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qhc.NHE(p, beta, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rhc.NHE(n, beta, lambda, theta)
hhc.NHE(x, beta, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dhc.NHE}: numeric vector of (log-)densities
  \item \code{phc.NHE}: numeric vector of probabilities
  \item \code{qhc.NHE}: numeric vector of quantiles
  \item \code{rhc.NHE}: numeric vector of random variates
  \item \code{hhc.NHE}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Half-Cauchy NHE distribution.
}
\details{
The Half-Cauchy NHE distribution is parameterized by the parameters
\eqn{\beta > 0}, \eqn{\lambda > 0}, and \eqn{\theta > 0}.


The Half-Cauchy NHE distribution has CDF:

\deqn{
F(x; \beta, \lambda, \theta) =
\frac{2}{\pi}
\arctan\left\{
-\frac{1}{\theta}
\left( 1 - (1 + \lambda x)^{\beta} \right)
\right\},
\quad x > 0.
}

where \eqn{\beta}, \eqn{\lambda}, and \eqn{\theta} are the parameters.

The implementation includes the following functions:
\itemize{
  \item \code{dhc.NHE()} — Density function
  \item \code{phc.NHE()} — Distribution function
  \item \code{qhc.NHE()} — Quantile function
  \item \code{rhc.NHE()} — Random generation
  \item \code{hhc.NHE()} — Hazard function
}
}
\examples{
x <- seq(1.0, 5, 0.25)
dhc.NHE(x, 2.0, 0.5, 2.5)
phc.NHE(x, 2.0, 0.5, 2.5)
qhc.NHE(0.5, 2.0, 0.5, 2.5)
rhc.NHE(10, 2.0, 0.5, 2.5)
hhc.NHE(x, 2.0, 0.5, 2.5)

# Data
x <- stress66
# ML estimates
params = list(beta=95.2115, lambda=0.0184, theta=118.0656)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = phc.NHE, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qhc.NHE, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dhc.NHE, pfun=phc.NHE, plot=TRUE)
print.gofic(out)

}
\references{
Chaudhary, A. K., & Kumar, V.(2021). 
Arctan Exponential Extension Distribution with Properties and Applications. 
\emph{International Journal of Applied Research (IJAR)}, \bold{7(1)}, 432--442. 
\doi{10.22271/allresearch.2021.v7.i1f.8251}

Telee, L. B. S., & Kumar, V. (2022). 
Some properties and applications of half-Cauchy exponential extension 
distribution.\emph{ Int. J. Stat. Appl. Math.}, \bold{7(6)}, 91--101. 
\doi{10.22271/maths.2022.v7.i6b.902} 

Kumar, V. (2010). Bayesian analysis of exponential extension model. 
\emph{J. Nat. Acad. Math.}, \bold{24}, 109-128.
}
