% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogisInvLomax.r
\name{LogisInvLomax}
\alias{LogisInvLomax}
\alias{dlogis.inv.lomax}
\alias{plogis.inv.lomax}
\alias{qlogis.inv.lomax}
\alias{rlogis.inv.lomax}
\alias{hlogis.inv.lomax}
\title{Logistic Inverted Lomax Distribution}
\usage{
dlogis.inv.lomax(x, alpha, beta, lambda, log = FALSE)
plogis.inv.lomax(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qlogis.inv.lomax(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rlogis.inv.lomax(n, alpha, beta, lambda)
hlogis.inv.lomax(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlogis.inv.lomax}: numeric vector of (log-)densities
  \item \code{plogis.inv.lomax}: numeric vector of probabilities
  \item \code{qlogis.inv.lomax}: numeric vector of quantiles
  \item \code{rlogis.inv.lomax}: numeric vector of random variates
  \item \code{hlogis.inv.lomax}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Logistic Inverted Lomax distribution.
}
\details{
The Logistic Inverted Lomax distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Logistic Inverted Lomax distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad 1 - {\left[ {1 + {{\left\{ {{{\left( {1 + \frac{\beta }{x}} \right)}
^\lambda } - 1} \right\}}^\alpha }} \right]^{ - 1}}\quad ;\,x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dlogis.inv.lomax()} — Density function
  \item \code{plogis.inv.lomax()} — Distribution function
  \item \code{qlogis.inv.lomax()} — Quantile function
  \item \code{rlogis.inv.lomax()} — Random generation
  \item \code{hlogis.inv.lomax()} — Hazard function
}
}
\examples{
x <- seq(0.1, 10, 0.2)
dlogis.inv.lomax(x, 2.0, 5.0, 0.2)
plogis.inv.lomax(x, 2.0, 5.0, 0.2)
qlogis.inv.lomax(0.5, 2.0, 5.0, 0.2)
rlogis.inv.lomax(10, 2.0, 5.0, 0.2)
hlogis.inv.lomax(x, 2.0, 5.0, 0.2)

# Data
x <- bladder
# ML estimates
params = list(alpha=2.87951, beta=38.51405, lambda=0.35313)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plogis.inv.lomax, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlogis.inv.lomax, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlogis.inv.lomax, pfun=plogis.inv.lomax, plot=FALSE)
print.gofic(out)

}
\references{
Joshi, R. K., & Kumar, V. (2021). 
The Logistic Inverse Lomax Distribution with Properties and Applications. 
\emph{International Journal of Mathematics and Computer Research}, 
\bold{9(1)}, 2169--2177. \doi{10.47191/ijmcr/v9i1.02}  

Lan, Y., & Leemis, L. M. (2008). The Logistic-Exponential Survival Distribution. 
\emph{Naval Research Logistics},  \bold{55},  252--264.
}
