% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModUbd.r
\name{ModUbd}
\alias{ModUbd}
\alias{dmod.ubd}
\alias{pmod.ubd}
\alias{qmod.ubd}
\alias{rmod.ubd}
\alias{hmod.ubd}
\title{Modified UBD (MUBD) Distribution}
\usage{
dmod.ubd(x, alpha, beta, lambda, log = FALSE)
pmod.ubd(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qmod.ubd(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rmod.ubd(n, alpha, beta, lambda)
hmod.ubd(x, alpha, beta, lambda)
}
\arguments{
\item{x}{Vector of positive quantiles.}

\item{alpha}{Shape parameter (\eqn{\alpha > 0}).}

\item{beta}{Shape parameter (\eqn{\beta > 0}).}

\item{lambda}{Scale parameter (\eqn{\lambda > 0}).}

\item{log}{Logical; if TRUE, returns the log-density.}

\item{q}{Vector of positive quantiles.}

\item{lower.tail}{Logical; if TRUE (default), returns \eqn{P(X \le x)}.}

\item{log.p}{Logical; if TRUE, probabilities are returned on the log scale.}

\item{p}{Vector of probabilities.}

\item{n}{Number of random observations. Must be a positive integer.}
}
\value{
\code{dmod.ubd} returns the probability density function.  
\code{pmod.ubd} returns the cumulative distribution function.  
\code{qmod.ubd} returns the quantile function.  
\code{rmod.ubd} generates random variates.  
\code{hmod.ubd} returns the hazard rate function.
}
\description{
Density, distribution function, quantile function, random generation,
and hazard rate function for the Modified UBD (MUBD) distribution.
}
\details{
The Modified UBD (MUBD) distribution is a flexible lifetime distribution
with positive shape parameters \eqn{\alpha > 0}, \eqn{\beta > 0}
and scale parameter \eqn{\lambda > 0}.

The MUDB distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad 1-\exp \left\{1-\left(1+x^\beta e^{-\lambda / x}\right)
^\alpha\right\}  \quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.
}
\examples{
x <- seq(0.1, 1, by=0.1)
dmod.ubd(x, alpha = 1.5, beta = 1.2, lambda = 2)
pmod.ubd(x, alpha = 1.5, beta = 1.2, lambda = 2)
qmod.ubd(0.5, alpha = 1.5, beta = 1.2, lambda = 2)
rmod.ubd(10, alpha = 1.5, beta = 1.2, lambda = 2)
hmod.ubd(x, alpha = 1.5, beta = 1.2, lambda = 2)

# Data
x <- fibers69
# ML estimates
params = list(alpha=0.8559, beta=3.0133, lambda=7.0336)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pmod.ubd, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qmod.ubd, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dmod.ubd, pfun=pmod.ubd, plot=TRUE)
print.gofic(out)

}
\references{
Chaudhary, A.K., Telee, L. B. S., & Kumar, V. (2023).
Modified Upside Down Bathtub-Shaped Hazard Function Distribution:
Properties and Applications. \emph{Journal of Econometrics and Statistics},
\bold{3(1)}, 107--120.
}
