% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoissonChen.r
\name{PoissonChen}
\alias{PoissonChen}
\alias{dpois.chen}
\alias{ppois.chen}
\alias{qpois.chen}
\alias{rpois.chen}
\alias{hpois.chen}
\title{Poisson-Chen Distribution}
\usage{
dpois.chen(x, alpha, beta, lambda, log = FALSE)
ppois.chen(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qpois.chen(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rpois.chen(n, alpha, beta, lambda)
hpois.chen(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dpois.chen}: numeric vector of (log-)densities
  \item \code{ppois.chen}: numeric vector of probabilities
  \item \code{qpois.chen}: numeric vector of quantiles
  \item \code{rpois.chen}: numeric vector of random variates
  \item \code{hpois.chen}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Poisson-Chen distribution.
}
\details{
The Poisson-Chen distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Poisson-Chen distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad 1 - \frac{1}{{1 - {e^{ - \lambda }}}}\left[ {1 - \exp \left\{ 
{ - \lambda \,\,{e^{\beta (1 - {e^{{x^\alpha }}})\,}}} \right\}} 
\right]\quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dpois.chen()} — Density function
  \item \code{ppois.chen()} — Distribution function
  \item \code{qpois.chen()} — Quantile function
  \item \code{rpois.chen()} — Random generation
  \item \code{hpois.chen()} — Hazard function
}
}
\examples{
x <- seq(0.1, 2.0, 0.2)
dpois.chen(x, 2.0, 0.5, 0.2)
ppois.chen(x, 2.0, 0.5, 0.2)
qpois.chen(0.5, 2.0, 0.5, 0.2)
rpois.chen(10, 2.0, 0.5, 0.2)
hpois.chen(x, 2.0, 0.5, 0.2)

# Data
x <- fibers63
# ML estimates
params = list(alpha=0.53679, beta=1.00238, lambda=108.22948)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = ppois.chen, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qpois.chen, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dpois.chen, pfun=ppois.chen, plot=TRUE)
print.gofic(out)

}
\references{
Joshi, R. K., & Kumar, V. (2021).  
Poisson Chen Distribution: Properties and Application. 
\emph{ International Journal of Latest Trends in Engineering and Technology}, 
\bold{18(4)}, 1--12.
}
