\name{relief}
\alias{relief}
\title{Relief Times of Patients Receiving an Analgesic}

\description{
This dataset contains the relief times (in hours) of 20 patients who received
an analgesic. The data were originally presented by Gross and Clark (1976) in
their work on survival distributions and reliability applications in
biomedical sciences.
}

\usage{
relief
}

\format{
A numeric vector of length 20 containing relief times in hours.
}

\value{
An object of class \code{"numeric"}.

The vector consists of 20 observed relief times (in hours), each corresponding
to a single patient who received an analgesic treatment. Each value represents
the time elapsed from administration of the analgesic to the onset of pain
relief. The dataset is commonly used in survival and reliability analysis to
illustrate lifetime distributions, time-to-event modeling, and nonparametric
estimation techniques.
}

\details{
The dataset is frequently used in survival analysis to illustrate basic
distributional behavior, reliability concepts, and nonparametric survival
estimation. It serves as a benchmark example in many survival analysis
textbooks.
}

\references{
Gross, A. J., & Clark, V. A. (1976).
\emph{Survival Distributions: Reliability Applications in the Biomedical
Sciences}. Wiley, New York.
}

\examples{
summary(relief)

hist(
  relief,
  main = "Relief Times Histogram",
  xlab = "Relief Time (hours)"
)

plot(
  relief,
  type = "b",
  main = "Relief Times",
  xlab = "Patient",
  ylab = "Time (hours)"
)
}

\keyword{datasets}

