% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_ncbi_clinvar.R
\name{search_ncbi_clinvar}
\alias{search_ncbi_clinvar}
\title{Search for pathogenicity information in NCBI ClinVar}
\usage{
search_ncbi_clinvar(pathogenicity, genes_mutated, total_codifications)
}
\arguments{
\item{pathogenicity}{Ordered list. Existing pathogenicity data.}

\item{genes_mutated}{Ordered list. Existing mutated gene data.}

\item{total_codifications}{Ordered list. Existing mutated gen codification data.}
}
\value{
An updated list of pathogenicity classifications based on NCBI ClinVar search results.
}
\description{
This function queries the NCBI ClinVar database for germline classifications based on gene and codification data.
}
\examples{
\donttest{
InputPath <- system.file("extdata", package = "ORscraper")
files <- read_pdf_files(InputPath)
lines <- read_pdf_content(files[1])  # Example with the first file

genes_file <- system.file("extdata/Genes.xlsx", package = "ORscraper")

if (requireNamespace("readxl", quietly = TRUE)) {
  genes <- readxl::read_excel(genes_file)
  mutations <- unique(genes$GEN)

  TableValues <- extract_values_from_tables(lines, mutations)
  mutateGenes <- TableValues[[1]]
  pathogenity <- TableValues[[2]]
  codifications <- TableValues[[4]]

  search_pathogenity <- search_ncbi_clinvar(pathogenity, mutateGenes, codifications)
}
}

}
