% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_OSLcomponents.R
\name{simulate_OSLcomponents}
\alias{simulate_OSLcomponents}
\title{Simulates signal component decay curves and whole CW-OSL curves}
\usage{
simulate_OSLcomponents(
  components,
  curve = NULL,
  channel.width = 0.1,
  channel.number = 400,
  simulate.curve = FALSE,
  add.poisson.noise = TRUE,
  add.gaussian.noise = 0,
  add.background = 0,
  round.values = TRUE
)
}
\arguments{
\item{components}{\link{data.frame} (\strong{required}):
Table with component parameters. The table requires columns \verb{$names}, \verb{$lambda} and \verb{$n}, see section \strong{Examples}.}

\item{curve}{\link{data.frame} (\emph{optional}):
CW-OSL curve serving as template for the time axis. The input table requires a column \verb{$time}.
If no input object is given or the object contains no column \verb{$signal},
\code{simulate.curve} will be set \code{TRUE}.}

\item{channel.width}{\link{numeric} (\emph{optional}):
Channel width in seconds. Necessary for curve simulation if \code{curve} is not given.}

\item{channel.number}{\link{numeric} (\emph{optional}):
Number of channels resp. data points. Necessary for curve simulation if \code{curve} is not given.}

\item{simulate.curve}{\link{logical} (\emph{with default}):
Decides if the bulk CW-OSL signal shall be calculated from the component parameter.
If \code{FALSE}, the output curve will take over the column \verb{$signal} from the input \code{curve}.
If \code{TRUE}, a new column \verb{$signal} will be created which is the sum of all component curves.}

\item{add.poisson.noise}{\link{logical} (\emph{with default}):
Adds poisson distributed shot noise to \verb{$signal} if \code{simulate.curve = TRUE}.}

\item{add.gaussian.noise}{\link{numeric} (\emph{with default}):
Standard deviation of the detector noise in \emph{cts/s}, added to \verb{$signal} if \code{simulate.curve = TRUE}.}

\item{add.background}{\link{numeric} (\emph{with default}):
signal background level in \emph{cts/s}, added to \verb{$signal} if \code{simulate.curve = TRUE}}

\item{round.values}{\link{logical} (\emph{with default}):
Rounds \verb{$signal} values to integers if \code{simulate.curve = TRUE}.}
}
\value{
A \link{data.frame} of a CW-OSL curve with the columns: \verb{$time}, \verb{$signal}, \verb{$residual}, \verb{$sum}
and a signal decay curve for each single component named after the entries in the column \code{components$names}
of the input object.
}
\description{
This function builds a bulk CW-OSL curve and CW-OSL component decay curves from OSL component parameters.
Therewith it supports \link{fit_OSLcurve}, \link{decompose_OSLcurve} and \link{plot_OSLcurve} by providing model and residual curves.
}
\section{Last updates}{


2020-10-30, DM: Renamed from \emph{simulate_OSLcurve} to \emph{simulate_OSLcomponents};
Renamed argument from \emph{template.curve} to \emph{curve}; Rewrote roxygen documentation
}

\examples{

# Set some arbitrary decay parameter for a dim CW-OSL measurement of quartz
components <- data.frame(name = c("fast", "medium", "slow"),
                         lambda = c(2, 0.5, 0.02),
                         n = c(1000, 1000, 10000))

# Simulate the CW-OSL curve and add some signal noise
curve <- simulate_OSLcomponents(components, simulate.curve = TRUE, add.poisson.noise = TRUE)

# Display the simulated curve
plot_OSLcurve(curve, components)

}
\references{
Mittelstraß, D., 2019. Decomposition of weak optically stimulated luminescence signals and its application in retrospective dosimetry at quartz (Master thesis). TU Dresden, Dresden.
}
\seealso{
\link{fit_OSLcurve}, \link{decompose_OSLcurve}, \link{plot_OSLcurve}
}
\author{
Dirk Mittelstraß, \email{dirk.mittelstrass@luminescence.de}

Please cite the package the following way:

Mittelstraß, D., Schmidt, C., Beyer, J., Heitmann, J. and Straessner, A.:
R package OSLdecomposition: Automated identification and separation of quartz CW-OSL signal components, \emph{in preparation}.
}
