% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM.R
\name{EM}
\alias{EM}
\title{EM algorithm for a univariate Gaussian mixture}
\usage{
EM(X, K = 2, max_iter = 100, tol = 1e-05)
}
\arguments{
\item{X}{Numeric vector of observations.}

\item{K}{Integer. Number of mixture components.}

\item{max_iter}{Integer. Maximum number of EM iterations.}

\item{tol}{Positive numeric. Convergence tolerance for the absolute change in
the log-likelihood.}
}
\value{
A list with the following components:
\describe{
  \item{mu}{Numeric vector of estimated component means (length \code{K}).}
  \item{sigma}{Numeric vector of estimated component standard deviations (length \code{K}).}
  \item{pi}{Numeric vector of estimated mixing proportions (length \code{K}).}
  \item{num_iteraciones}{Number of iterations performed.}
  \item{posterior}{Matrix of posterior probabilities (responsibilities) with
  dimension \code{length(X)} by \code{K}.}
}
}
\description{
Fits a univariate Gaussian mixture model using the Expectation-Maximization (EM)
algorithm. The function is intended as a lightweight fallback implementation
(e.g., when \pkg{mixtools} is unavailable or fails).
}
\details{
The algorithm is initialized using the k-means clustering procedure
and then alternates between:
\enumerate{
  \item E-step: computing the expectation of the complete log-likelihood function.
  \item M-step: maximizing the expectation of the complete log-likelihood function.
}
}
\examples{
set.seed(1)
x <- c(rnorm(100, -2, 1), rnorm(100, 2, 1))
fit <- EM(x, K = 2)
fit$mu
fit$pi

}
