% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OVL.GPQ.R
\name{OVL.GPQ}
\alias{OVL.GPQ}
\title{OVL.GPQ}
\usage{
OVL.GPQ(x, y, alpha = 0.05, K = 2500, h_ini = -1.6, BC = FALSE)
}
\arguments{
\item{x}{Numeric vector. Data from the first group.}

\item{y}{Numeric vector. Data from the second group.}

\item{alpha}{confidence level.}

\item{K}{Number of simulated generalized pivotal quantities.}

\item{h_ini}{initial value in the optimization problem.}

\item{BC}{Logical. Indicates whether a Box–Cox transformation is applied to the data.}
}
\value{
confidence interval.
}
\description{
Parametric approach based on generalized inference.
}
\examples{
controls = rnorm(50,6,1)
cases = rnorm(100,6.5,0.5)
OVL.GPQ (controls,cases)
}
