% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohortQueries.R
\name{getCohortInclusionRules}
\alias{getCohortInclusionRules}
\title{Extract the cohort inclusion rules}
\usage{
getCohortInclusionRules(
  connectionHandler,
  schema,
  cgTablePrefix = "cg_",
  cohortIds = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{cohortIds}{Optionally a list of cohortIds to restrict to}
}
\value{
Returns a data.frame with the cohort inclusion rules
}
\description{
This function extracts all cohort inclusion rules for the cohorts of interest.
}
\details{
Specify the connectionHandler, the schema and the cohort IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

cohortInclsuionsRules <- getCohortInclusionRules(
  connectionHandler = connectionHandler, 
  schema = 'main'
)

}
\seealso{
Other Cohorts: 
\code{\link{getCohortCounts}()},
\code{\link{getCohortDefinitions}()},
\code{\link{getCohortInclusionStats}()},
\code{\link{getCohortInclusionSummary}()},
\code{\link{getCohortMeta}()},
\code{\link{getCohortSubsetDefinitions}()},
\code{\link{processCohorts}()}
}
\concept{Cohorts}
