% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CharacterzationQueries.R
\name{getIncidenceRates}
\alias{getIncidenceRates}
\title{Extract the cohort incidence result}
\usage{
getIncidenceRates(
  connectionHandler,
  schema,
  ciTablePrefix = "ci_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  targetIds = NULL,
  outcomeIds = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{ciTablePrefix}{The prefix used for the cohort incidence results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{targetIds}{A vector of integers corresponding to the target cohort IDs}

\item{outcomeIds}{A vector of integers corresponding to the outcome cohort IDs}
}
\value{
Returns a data.frame with the columns:
\itemize{
 \item{databaseName the name of the database}
 \item{databaseId the unique id of the database}
 \item{targetName the target cohort name}
 \item{targetId the target cohort unique identifier}
 \item{outcomeName the outcome name}
 \item{outcomeId the outcome unique identifier}
 \item(tar the friendly time-at-risk string)
 \item{cleanWindow clean windown around outcome}
 \item{subgroupName name for the result subgroup}
 \item{ageGroupName name for the result age group}
 \item{genderName name for the result gender group}
 \item{startYear name for the result start year}
 \item{tarStartWith time at risk start reference}
 \item{tarStartOffset time at risk start offset from reference}
 \item{tarEndWith time at risk end reference}
 \item{tarEndOffset time at risk end offset from reference}
 \item{personsAtRiskPe persons at risk per event}
 \item{personsAtRisk persons at risk}
 \item{personDaysPe person days per event}
 \item{personDays person days}
 \item{personOutcomesPe person outcome per event}
 \item{personOutcomes persons outcome}
 \item{outcomesPe number of outcome per event}
 \item{outcomes number of outcome}
 \item{incidenceProportionP100p incidence proportion per 100 persons}
 \item{incidenceRateP100py incidence rate per 100 person years}
 }
}
\description{
This function extracts all incidence rates across databases in the results for specified target and outcome cohorts.
}
\details{
Specify the connectionHandler, the schema and the target/outcome cohort IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

ir <- getIncidenceRates(
connectionHandler = connectionHandler, 
schema = 'main'
)

}
\seealso{
Other Characterization: 
\code{\link{getBinaryCaseSeries}()},
\code{\link{getBinaryRiskFactors}()},
\code{\link{getCaseBinaryFeatures}()},
\code{\link{getCaseContinuousFeatures}()},
\code{\link{getCaseCounts}()},
\code{\link{getCaseTargetBinaryFeatures}()},
\code{\link{getCaseTargetCounts}()},
\code{\link{getCharacterizationCohortBinary}()},
\code{\link{getCharacterizationCohortContinuous}()},
\code{\link{getCharacterizationDemographics}()},
\code{\link{getCharacterizationOutcomes}()},
\code{\link{getCharacterizationTargets}()},
\code{\link{getContinuousCaseSeries}()},
\code{\link{getContinuousRiskFactors}()},
\code{\link{getDechallengeRechallenge}()},
\code{\link{getDechallengeRechallengeFails}()},
\code{\link{getIncidenceOutcomes}()},
\code{\link{getIncidenceTargets}()},
\code{\link{getTargetBinaryFeatures}()},
\code{\link{getTargetContinuousFeatures}()},
\code{\link{getTimeToEvent}()},
\code{\link{plotAgeDistributions}()},
\code{\link{plotSexDistributions}()}
}
\concept{Characterization}
