% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{addSamples}
\alias{addSamples}
\title{Add sample metadata}
\usage{
addSamples(study, samples, reset = FALSE)
}
\arguments{
\item{study}{An OmicNavigator study created with \code{\link{createStudy}}}

\item{samples}{The metadata variables that describe the samples in the study.
The input object is a named list of data frames (one per model). The first
column of each data frame is used as the sampleID, so it must contain
unique values. To share a data frame across multiple models, use the
modelID "default".}

\item{reset}{Reset the data prior to adding the new data (default:
\code{FALSE}). The default is to add to or modify any previously added data
(if it exists). Setting \code{reset = TRUE} enables you to remove existing
data you no longer want to include in the study.}
}
\value{
Returns the original \code{onStudy} object passed to the argument
\code{study}, but modified to include the newly added data
}
\description{
Add sample metadata
}
\seealso{
\code{\link{getSamples}}
}
