% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\docType{data}
\name{analysis}
\alias{analysis}
\title{analysis dataset}
\format{
A labelled tibble with 123 rows and 33 variables:
\describe{
\item{age}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Age in years \cr
}


}
\item{sex}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Male}) \cr
    \tab  \cr
   \emph{Description:} \tab Sex assigned at Birth \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Male, Female} \cr
}


}
\item{recur_site}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Supra}) \cr
    \tab  \cr
   \emph{Description:} \tab Recurrent Site \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Supra, Glottic, Transglottic, Unknown} \cr
}


}
\item{trt_mod}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{XRT}) \cr
    \tab  \cr
   \emph{Description:} \tab Treatment Modality \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{XRT, Chemo+XRT, Unspecified} \cr
}


}
\item{int_stg}{\tabular{ll}{
   \emph{Type:} \tab ordered (First/Reference level = \code{Unknown}) \cr
    \tab  \cr
   \emph{Description:} \tab Initial Stage \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Unknown, T1, T2, T3, T4} \cr
}


}
\item{recur_stg}{\tabular{ll}{
   \emph{Type:} \tab ordered (First/Reference level = \code{Unknown}) \cr
    \tab  \cr
   \emph{Description:} \tab Recurrent staging \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Unknown, T1, T2, T3, T4} \cr
}


}
\item{preop_img_mod}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{CT}) \cr
    \tab  \cr
   \emph{Description:} \tab Imaging \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{CT, PET, CT+PET, MRI} \cr
}


}
\item{nk_dissection}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab Neck Dissection \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{laterality}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Bilateral}) \cr
    \tab  \cr
   \emph{Description:} \tab Laterality \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Bilateral, Unilateral} \cr
}


}
\item{mic_vas_flap}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab Microvascular Flap \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{pec_flap}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab Pectoralis major myocutaneous flap \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{pathology}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Positive}) \cr
    \tab  \cr
   \emph{Description:} \tab Nodal Pathology evaluation of specimen \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Positive, Negative} \cr
}


}
\item{path_stg}{\tabular{ll}{
   \emph{Type:} \tab ordered (First/Reference level = \code{Unknown}) \cr
    \tab  \cr
   \emph{Description:} \tab Pathologic staging \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Unknown, T1, T2, T3, T4} \cr
}


}
\item{complications}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab Complications \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{fistula}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab Salivary fistula or leak \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{wound_inf}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab Wound Infection \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{dehiscence}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab Wound dehiscence \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{wound_comp}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab Wound Complications \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{chyle_leak}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab Chyle leak \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{hematoma}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab Hematoma \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{revision_proc}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab Revision procedure \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{flap_fail}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab Flap Failure \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{periop_death}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab Perioperative Death \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{med_comp}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab Medical Complications \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{comp_2plus}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab 2 or more complications \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{hosp_stay_days}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Hospital Stay \cr
}


}
\item{death}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab Death status \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{recur}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \code{Yes}) \cr
    \tab  \cr
   \emph{Description:} \tab Recurrence status \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{Yes, No} \cr
}


}
\item{sor}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = \verb{No recurrence}) \cr
    \tab  \cr
   \emph{Description:} \tab Site of Recurrence after salvage laryngectomy \cr
    \tab  \cr
   \emph{Levels:} \tab \verb{No recurrence, Local/regional, Distant} \cr
}


}
\item{length_fu}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Days of follow-up \cr
}


}
\item{death_fu}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Days until death \cr
}


}
\item{recur_fu}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Days until recurrence \cr
}


}
\item{complications_count}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Number of complications \cr
}


}
}
}
\usage{
analysis
}
\description{
This dataset, which is ready for analysis, was created by
setting the variable types, specifying factor levels instead of code numbers,
and applying labels to the laryngectomy dataset. It includes demographics,
surgery details, and outcomes for 123 individuals who underwent
a laryngectomy at an unspecified medical center between 2000 and 2012.
}
\keyword{datasets}
