% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm.R
\name{openmap}
\alias{openmap}
\title{Get a map based on lat long coordinates}
\usage{
openmap(
  upperLeft,
  lowerRight,
  zoom = NULL,
  type = c("osm", "osm-german", "esri", "esri-topo", "esri-physical", "esri-shaded",
    "esri-imagery", "esri-terrain", "esri-natgeo", "nps", "apple-iphoto",
    "osm-public-transport"),
  minNumTiles = 9L,
  mergeTiles = TRUE
)
}
\arguments{
\item{upperLeft}{the upper left lat and long}

\item{lowerRight}{the lower right lat and long}

\item{zoom}{the zoom level. If null, it is determined automatically}

\item{type}{the tile server from which to get the map, or the url pattern.}

\item{minNumTiles}{If zoom is null, zoom will be chosen such that
the number of map tiles is greater than or equal
to this number.}

\item{mergeTiles}{should map tiles be merged into one tile}
}
\description{
Get a map based on lat long coordinates
}
\details{
Type may be the url of a custom tile server (http://wiki.osgeo.org/wiki/Tile_Map_Service_Specification).
should include \{z\}, \{y\}, and \{x\} specifying where the zoom, xtile and ytile location should be substituted. e.g.

http://api.someplace.com/.../\{z\}/\{x\}/\{y\}.png
}
\examples{
\dontrun{
# Some of the maps available
nm <- c("osm","osm-german","esri","esri-topo","esri-physical","esri-shaded",
  "esri-imagery","esri-terrain","esri-natgeo","nps","apple-iphoto")
par(mfrow=c(3,4), mar=c(0,0,0,0))
#Korea
for(i in 1:length(nm)){
	map <- openmap(c(43.46886761482925,119.94873046875),
			c(33.22949814144951,133.9892578125),
		minNumTiles=3,type=nm[i])
plot(map)
}
# Maps from custom urls (use your own API key)
apiKey <- paste0("?access_token=",
 "pk.eyJ1IjoidGhlZmVsbCIsImEiOiJjaXN1anNwODEwMWlrMnRvZHBhamRrZjlqIn0.Gf8qLSpZ6yo5yfQhEutFfQ")
baseUrl <- "https://api.mapbox.com/styles/v1/mapbox/satellite-streets-v9/tiles/256/{z}/{x}/{y}"
map <- openmap(c(43.46886761482925,119.94873046875),
	c(33.22949814144951,133.9892578125),
		minNumTiles=4,
		type=paste0(baseUrl,apiKey))
plot(map)



# Plot Korea with ggplot2.
library(ggplot2)
map <- openmap(c(43.46886761482925,119.94873046875),
	c(33.22949814144951,133.9892578125),
	minNumTiles=4)
autoplot(map)

# Lambert Conic Conformal Map Projection
map_llc <- openproj(map, projection=
"+proj=lcc +lat_1=33 +lat_2=45 +lat_0=39 +lon_0=-96")
plot(map_llc,removeMargin=TRUE)


}
}
