% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graph_B_sets.R
\name{B_sets_make_unique}
\alias{B_sets_make_unique}
\title{Compress a given collection of B-sets}
\usage{
B_sets_make_unique(B_sets)
}
\arguments{
\item{B_sets}{a boolean matrix with \code{(2 + length(children))}
columns and \code{length(parents)} rows.
They are assumed to be sorted in increasing order of row sums,
i.e. by increasing order of set cardinality.
Typically, this will be the output of \code{find_B_sets_v}
for some node \code{v}.}
}
\value{
a `data.frame` made of the unique rows of `B_sets`.
An additional column `nodes` is added at the start. It contains all the children
of \code{v} corresponding to this B-set.
}
\description{
Compress a given collection of B-sets
}
\examples{
DAG = create_empty_DAG(5)
DAG = bnlearn::set.arc(DAG, 'U1', 'U4')
DAG = bnlearn::set.arc(DAG, 'U2', 'U4')
DAG = bnlearn::set.arc(DAG, 'U3', 'U4')
DAG = bnlearn::set.arc(DAG, 'U4', 'U5')
B_sets = find_B_sets_v(DAG, v = 'U4')

B_sets_make_unique(B_sets)

}
