% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CopulaAssignement_possibleCandidates.R
\name{possible_candidates}
\alias{possible_candidates}
\alias{possible_candidate_incoming_arc}
\alias{possible_candidate_outgoing_arc}
\title{Possible candidates to be added to a partial order}
\usage{
possible_candidates(DAG, v, order_v, order_hash, B_minus_O)

possible_candidate_incoming_arc(DAG, w, v, order_v, order_hash)

possible_candidate_outgoing_arc(DAG, w, v, order_v, order_hash)
}
\arguments{
\item{DAG}{Directed Acyclic Graph.}

\item{order_v}{partial order for node v.}

\item{order_hash}{hashmap of parental orders}

\item{B_minus_O}{this is the current B-set, without the elements of
\code{order_v}, i.e. this is the set of elements that could be considered
possible candidates.}

\item{w, v}{nodes in DAG. \code{w} is assumed to be a parent of \code{v}.}
}
\value{
\code{possible_candidates} returns a vector of possible candidates,
potentially empty.
Both \code{possible_candidate_incoming_arc} and
\code{possible_candidate_outgoing_arc} return either a node \code{o}, or
\code{NULL} if they could not find such a node.
}
\description{
When given a partial order of a PCBN, one can complete it by adding one
of the parents' node to the partial order. Some nodes can be added; they are
then called "possible candidates".
}
\details{
\code{possible_candidate_incoming_arc} returns a node \code{o} such \code{w}
is a parent of \code{o}, and \code{w} can be used as an incoming arc to
\code{v} by the node \code{o}. If no such \code{o} can be found, \code{w}
cannot be used as a potential candidate for the order of \code{v} by incoming
arc. Then, the function \code{possible_candidate_incoming_arc} returns
\code{NULL}.

In the same way, \code{possible_candidate_outgoing_arc} returns a node
\code{o} such \code{o} is a parent of \code{w}, and \code{w} can be used as
an outgoing arc to \code{v} by the node \code{o}.
}
\examples{

DAG = create_empty_DAG(4)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')
DAG = bnlearn::set.arc(DAG, 'U1', 'U4')
DAG = bnlearn::set.arc(DAG, 'U2', 'U4')
DAG = bnlearn::set.arc(DAG, 'U3', 'U4')

order_hash = r2r::hashmap()
order_hash[['U3']] = c("U1", "U2")

# Node of interest
v = "U4"

# If we start by 1, then the arc 1 -> 3 cannot be used as an incoming arc
# (it is actually an outgoing arc)
possible_candidate_incoming_arc(
  DAG = DAG, w = "U3", v = v, order_v = c("U1"), order_hash = order_hash)
possible_candidate_outgoing_arc(
  DAG = DAG, w = "U3", v = v, order_v = c("U1"), order_hash = order_hash)
possible_candidates(
  DAG = DAG, v = v, order_v = c("U1"), order_hash = order_hash, B_minus_O = "U2")


}
\seealso{
\code{\link{dsep_set}} for checking whether two sets of nodes are d-separated
by another set.
\code{\link{find_B_sets}} to find the B-sets.
}
