% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeTableAncestors}
\alias{PCMTreeTableAncestors}
\title{A matrix (table) of ancestors/descendants for each node in a tree}
\usage{
PCMTreeTableAncestors(tree, preorder = PCMTreePreorder(tree))
}
\arguments{
\item{tree}{a phylo object}

\item{preorder}{an integer vector returned by a previous call to
\code{PCMTreePreorder(tree)}. Default \code{PCMTreePreorder(tree)}.}
}
\value{
an integer square matrix of size M x M where M is the number of nodes
in the tree. Element j on row i is 0 if j is not an ancestor of i or a positive
integer equal to the position of j on the path from the root to i if j is an
ancestor of i.
}
\description{
A matrix (table) of ancestors/descendants for each node in a tree
}
\details{
This function has time and memory complexity O(M^2), where M is the
 number of nodes in the tree. It can take several minutes and gigabytes of
 memory on trees of more than 10000 tips.
}
