% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_output_functions.R
\name{f_plot_diag_param_surv_model}
\alias{f_plot_diag_param_surv_model}
\title{Diagnostic Plot for Parametric Survival Models}
\usage{
f_plot_diag_param_surv_model(PERSUADE, model_index = 1)
}
\arguments{
\item{PERSUADE}{A PERSUADE object created by \code{\link[=f_PERSUADE]{f_PERSUADE()}}.}

\item{model_index}{Integer. Index of the parametric model in
\code{PERSUADE$surv_pred$model}.}
}
\value{
A base R diagnostic plot for the selected parametric survival model.
}
\description{
Produces diagnostic plots for standard parametric survival models, using
appropriate transformations depending on the model family (exponential,
Weibull, Gompertz, log-normal, log-logistic, gamma, generalized gamma).
}
\examples{
\donttest{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
PERSUADE <- f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = FALSE,
  cure_mod = FALSE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
f_plot_diag_param_surv_model(PERSUADE, model_index = 1)
}

}
\seealso{
\code{\link[=f_PERSUADE]{f_PERSUADE()}}
}
