% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.PPTreeExtclass.R
\name{plot.PPtreeExtclass}
\alias{plot.PPtreeExtclass}
\title{Plot Projection Pursuit Classification Tree}
\usage{
\method{plot}{PPtreeExtclass}(
  x,
  font.size = 17,
  width.size = 1,
  main = "Projection Pursuit Classification Tree",
  sub = NULL,
  auto.scale = TRUE,
  min.width = NULL,
  min.height = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{PPtreeclass} or \code{PPtreeExtclass} 
containing the tree structure, projection vectors, and split points.}

\item{font.size}{Numeric. Font size for text labels in the plot. 
Default is 17. Will be automatically reduced for large trees when 
\code{auto.scale = TRUE}.}

\item{width.size}{Numeric. Width scaling factor for graphical elements 
(nodes, edges). Default is 1. Will be automatically adjusted for large 
trees when \code{auto.scale = TRUE}.}

\item{main}{Character string. Main title for the plot. 
Default is "Projection Pursuit Classification Tree".}

\item{sub}{Character string or NULL. Subtitle for the plot. 
Default is NULL (no subtitle).}

\item{auto.scale}{Logical. If TRUE (default), automatically adjusts plot 
dimensions and font size based on tree size. Recommended for trees with 
more than 20 terminal nodes or depth greater than 15.}

\item{min.width}{Numeric or NULL. Minimum width (number of terminal nodes) 
for the plot when \code{auto.scale = FALSE}. If NULL, uses the number of 
classes in the data. Default is NULL.}

\item{min.height}{Numeric or NULL. Minimum height (tree depth) for the plot 
when \code{auto.scale = FALSE}. If NULL, uses calculated tree depth. 
Default is NULL.}

\item{...}{Additional arguments (currently not used).}
}
\value{
Invisibly returns a list with:
\item{width}{Numeric. The width used for plotting (number of terminal nodes)}
\item{height}{Numeric. The height used for plotting (tree depth)}
\item{font.size}{Numeric. The final font size used (after auto-scaling)}
}
\description{
Visualizes a Projection Pursuit (PP) classification tree  using grid graphics.
The function creates a hierarchical tree diagram showing the structure of 
splits and terminal nodes with class assignments. Supports automatic scaling
for large trees.
}
\details{
The plot displays:
\itemize{
  \item \strong{Internal nodes}: Shown as ellipses with the projection used 
    for splitting (e.g., "proj1 * X")
  \item \strong{Terminal nodes}: Shown as gray rectangles with the assigned 
    class label
  \item \strong{Edges}: Labeled with split rules ("< cutN" for left child, 
    ">= cutN" for right child)
  \item \strong{Node IDs}: Small boxes at the top of each node
}

\strong{Auto-scaling behavior:}
When \code{auto.scale = TRUE} and the tree has more than 20 terminal nodes 
or depth greater than 15:
\itemize{
  \item Font size is reduced: \code{max(10, 17 - floor((n_terminal - 20) / 5))}
  \item Width size is reduced: \code{max(0.7, 1 - (n_terminal - 20) * 0.01)}
  \item Width is set to: \code{max(n_terminal, n_classes)}
  \item Height is set to: tree depth
}

\strong{Manual scaling:}
When \code{auto.scale = FALSE}, you can control dimensions with 
\code{min.width} and \code{min.height}.
}
\note{
This function requires the \code{grid} package. It will create a new graphics 
page using \code{grid.newpage()}.

For very large trees (>50 terminal nodes), consider:
\itemize{
  \item Exporting to a large PNG or PDF file
  \item Manually reducing \code{font.size} further
  \item Pruning the tree before plotting
}
}
\examples{
\donttest{
library(grid)
# Example with penguins dataset
data(penguins)
penguins <- na.omit(penguins[, -c(2,7)])
penguins_ppt <- PPtreeExtclass(species~bill_len + bill_dep +flipper_len +
 body_mass,  data = penguins, PPmethod = "PDA", srule = FALSE )

plot(penguins_ppt,
     main = "Penguins Classification with PPtreeExt",
      font.size = 8,        
width.size = 0.7)
}

}
