% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C01-weighted-km-estimator.R
\name{estimate_weighted_km}
\alias{estimate_weighted_km}
\title{Weighted Kaplan-Meier Estimation with Classic Greenwood Variance}
\usage{
estimate_weighted_km(
  data,
  time_var,
  event_var,
  treatment_var,
  weights,
  treatment_levels
)
}
\arguments{
\item{data}{A data.frame containing the complete-case analysis data.}

\item{time_var}{A character string specifying the name of the time variable.}

\item{event_var}{A character string specifying the name of the event variable.
Should be coded as 1 = event, 0 = censored.}

\item{treatment_var}{A character string specifying the name of the treatment
variable in \code{data}.}

\item{weights}{A numeric vector of propensity score weights with length equal
to nrow(data). Each observation has one weight corresponding to its observed
treatment group. For ATE: \eqn{w_i = 1/e_j(X_i)} where j is observed treatment.}

\item{treatment_levels}{A vector of unique treatment values (sorted). Should
match the levels from \code{estimate_ps()}.}
}
\value{
A list containing:
  \item{eval_times}{Numeric vector of all unique event times where survival
    is estimated.}
  \item{surv_estimates}{Matrix [n_times x n_groups] of survival estimates.
    Column names are treatment levels.}
  \item{surv_var}{Matrix [n_times x n_groups] of variances for survival.}
  \item{n_risk}{Matrix [n_times x n_groups] of weighted number at risk (R).}
  \item{n_event}{Matrix [n_times x n_groups] of weighted number of events (D).}
  \item{n_acc_event}{Matrix [n_times x n_groups] of cumulative weighted events up to each time.}
  \item{treatment_levels}{Treatment levels (column names for matrices).}
  \item{n_levels}{Number of treatment groups.}
}
\description{
Core estimation function for computing weighted Kaplan-Meier survival curves
with propensity score weights. Handles multiple treatment groups simultaneously
and uses the classic weighted Greenwood formula for variance estimation.
Estimate Weighted Kaplan-Meier Curves for All Treatment Groups

Computes weighted Kaplan-Meier survival estimates and variances for all
treatment groups using propensity score weights. Uses classic weighted
Greenwood formula: \eqn{Var[S(t)] = [S(t)]^2 \sum (D_l / (R_l (R_l - D_l)))}.
}
\details{
**Weighted Kaplan-Meier Formula:**

For treatment group j, at each event time \eqn{t_l}:
\deqn{R_l = \sum_{i: T_i \ge t_l, Z_i = j} w_{i,j}}
\deqn{D_l = \sum_{i: T_i = t_l, \delta_i = 1, Z_i = j} w_{i,j}}
\deqn{\hat{S}^w_j(t) = \prod_{t_l \le t} \left(1 - \frac{D_l}{R_l}\right)}

where \eqn{R_l} is the weighted number at risk and \eqn{D_l} is the weighted number of events.
Ties between events and censorings are handled using the Breslow method.

**Classic Weighted Greenwood Variance:**

\deqn{Var[\hat{S}^w_j(t)] = [\hat{S}^w_j(t)]^2 \sum_{t_l \le t} \frac{D_l}{R_l (R_l - D_l)}}

This is the standard weighted extension of Greenwood's formula. When all
weights equal 1, reduces to classical Greenwood's formula.

**Weight Structure:**

The weight vector has length nrow(data). Each observation i in treatment group j
has weight \eqn{w_i} based on its propensity score for group j. For ATE estimation,
\eqn{w_i = 1/e_j(X_i)}. When computing weighted KM for group j, only observations
with \eqn{Z_i = j} and their corresponding weights are used.

**Handling Edge Cases:**

- If weighted at-risk count \eqn{R_l = 0} at time t, survival remains constant
  after t (last observation censored).
- Variance is undefined when \eqn{R_l - D_l \le 0}; set to NA for that time point.
}
\keyword{internal}
