% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helping_functions.R
\name{binarize_data}
\alias{binarize_data}
\title{Binarize PCL-5 symptom scores}
\usage{
binarize_data(data)
}
\arguments{
\item{data}{A dataframe containing exactly 20 columns with PCL-5 item scores
 (output of rename_ptsd_columns). Each symptom should be scored
  on a 0-4 scale where:

\itemize{
  \item  0 = Not at all
  \item  1 = A little bit
  \item  2 = Moderately
  \item  3 = Quite a bit
  \item  4 = Extremely
}

 Note: This function should only be used with raw symptom scores before
 calculating the total score, as it will convert all values in the dataframe
 to 0/1, which would invalidate any total score column if present.}
}
\value{
A dataframe with the same structure as input but with all symptom
  scores converted to binary values:

\itemize{
  \item  0 = Symptom absent (original scores 0-1)
  \item  1 = Symptom present (original scores 2-4)
}
}
\description{
Converts PCL-5 symptom scores from their original 0-4 scale to binary values
(0/1) based on the clinical threshold for symptom presence (>=2).
}
\details{
The function implements the standard clinical threshold for PTSD symptom
presence where:

\itemize{
\item Scores of 0-1 ("Not at all" and "A little bit") → 0 (symptom absent)
\item  Scores of 2-4 ("Moderately" to "Extremely") → 1 (symptom present)
}
}
\examples{
# Create sample data
sample_data <- data.frame(
  matrix(sample(0:4, 20 * 10, replace = TRUE),
         nrow = 10,
         ncol = 20)
)
colnames(sample_data) <- paste0("symptom_", 1:20)

# Binarize scores
binary_data <- binarize_data(sample_data)
binary_data # Should only show 0s and 1s

}
