% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_ContUser}
\alias{plot_ContUser}
\title{Plot user-defined contaminants from evidence.txt}
\usage{
plot_ContUser(data, name_contaminant, extra_limit, subtitle = NULL)
}
\arguments{
\item{data}{A data.frame with columns 'fc.raw.file', 'variable', 'value'}

\item{name_contaminant}{Name of the contaminant shown in title}

\item{extra_limit}{Position where a h-line is plotted (for visual guidance)}

\item{subtitle}{Optional subtitle for plot}
}
\value{
GGplot object
}
\description{
Kolmogorov-Smirnoff p-values are plotted on top of each group.
High p-values indicate that Andromeda scores for contaminant peptides
are equal or higher compared to sample peptide scores, i.e. the probability that
sample peptides scores are NOT greater than contaminant peptide scores.
}
\examples{

 data = data.frame(fc.raw.file = letters[1:3],
                   variable = c(rep("spectralCount", 3),
                                 rep("intensity", 3),
                                 rep("above.thresh", 3),
                                 rep("score_KS", 3)),
                   value = c(10, 20, 15, 9, 21, 14, 0, 1, 1, 0.3, 0.01, 0.04))
 plot_ContUser(data, "myco", 5, "subtitle")

}
