% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PVBcorrect_functions.R
\name{acc_bg}
\alias{acc_bg}
\title{PVB correction by Begg and Greenes' method with asymptotic normal CI}
\usage{
acc_bg(data, test, disease, ci = FALSE, ci_level = 0.95, description = TRUE)
}
\arguments{
\item{data}{A data frame, with at least "Test" and "Disease" variables.}

\item{test}{The "Test" variable name, i.e. the test result. The variable must be in binary; positive = 1, negative = 0 format.}

\item{disease}{The "Disease" variable name, i.e. the true disease status. The variable must be in binary; positive = 1, negative = 0 format.}

\item{ci}{View confidence interval (CI). The default is \code{FALSE}.}

\item{ci_level}{Set the CI width. The default is 0.95 i.e. 95\% CI.}

\item{description}{Print the name of this analysis. The default is \code{TRUE}. This can be turned off for repeated analysis, for example in bootstrapped results.}
}
\value{
A list object containing:
\describe{
  \item{acc_results}{The accuracy results.}
}
}
\description{
PVB correction by Begg and Greenes' method with asymptotic normal CI. This is limited to no covariate.
}
\examples{
acc_bg(data = cad_pvb, test = "T", disease = "D")  # equivalent to result by acc_ebg()
acc_bg(data = cad_pvb, test = "T", disease = "D", ci = TRUE)
  # the CIs are slightly differerent from result by acc_ebg()
}
\references{
\enumerate{
  \item{Begg, C. B., & Greenes, R. A. (1983). Assessment of diagnostic tests when disease verification is subject to selection bias. Biometrics, 207–215.}
  \item{Harel, O., & Zhou, X.-H. (2006). Multiple imputation for correcting verification bias. Statistics in Medicine, 25(22), 3769–3786.}
  \item{Zhou, X.-H. (1993). Maximum likelihood estimators of sensitivity and specificity corrected for verification bias. Communications in Statistics-Theory and Methods, 22(11), 3177–3198.}
  \item{Zhou, X.-H. (1994). Effect of verification bias on positive and negative predictive values. Statistics in Medicine, 13(17), 1737–1745.}
  \item{Zhou, X.-H., Obuchowski, N. A., & McClish, D. K. (2011). Statistical Methods in Diagnostic Medicine (2nd ed.). John Wiley & Sons.}

}
}
