% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelData.R
\name{plot.PanelData}
\alias{plot.PanelData}
\title{Create basic plots of PanelData objects}
\usage{
\method{plot}{PanelData}(x, ..., plotting.variable = NA)
}
\arguments{
\item{x}{\code{PanelData} object}

\item{...}{Not used}

\item{plotting.variable}{character string specifying which variable to plot in the resulting figure. The values of this variable will be used to fill in cells on the resulting heatmap. Defaults to whatever is specified as the treatment variable.}
}
\value{
Returns a ggplot2 object created by \code{geom_tile()}. The basic figure shows units along the y-axis and time along the x-axis. The figure takes the form of a heatmap. The value of the plotting.variable argument is used to fill in the color of the cells.
}
\description{
Create basic plots of PanelData objects
}
\examples{
dem$rdata <- rnorm(nrow(dem))
d <- PanelData(dem, "wbcode2", "year", "dem", "y")
plot(d)
plot(d, plotting.variable = "rdata")
}
