% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smmSAR.R
\name{summary.smmSAR}
\alias{summary.smmSAR}
\alias{print.summary.smmSAR}
\alias{print.smmSAR}
\title{Summarizing SMM Estimation of SAR model}
\usage{
\method{summary}{smmSAR}(object, .fun, .args, sim = 30, ncores = 1, dnetwork, data, ...)

\method{print}{summary.smmSAR}(x, ...)

\method{print}{smmSAR}(x, dnetwork, .fun, .args, sim = NULL, ncores = 1, data, ...)
}
\arguments{
\item{object}{an object of class "smmSAR", output of the function \code{\link{smmSAR}}.}

\item{.fun, .args}{are used to simulate from the distribution of \code{dnetwork}. \code{.fun} is the simulator function
where \code{.args} is a list of its arguments. Typically \code{do.call(.fun, .args)} is supposed to simulate one \code{dnetwork} from
the distribution.}

\item{sim}{the number of simulations of \code{dnetwork}.}

\item{ncores}{the number of cores to be used for the simulation. Use a lot of cores for fast simulations.}

\item{dnetwork}{a list, where the m-th elements is the matrix of link probability in the m-th sub-network.}

\item{data}{optional data frame, list or environment (or object coercible by \link[base]{as.data.frame} to a data frame) containing the variables
in the model. If missing, the variables are taken from \code{environment(formula)}, typically the environment from which \code{smmSAR} is called.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class "summary.smmSAR" or "smmSAR", output of the functions \code{\link{summary.smmSAR}} or
\code{\link{smmSAR}}.}
}
\value{
A list consisting of:
\item{n.group}{number of groups.}
\item{N}{vector of each group size.}
\item{estimates}{vector of estimated parameters.}
\item{formula}{input value of \code{formula}.}
\item{contextual}{input value of \code{contextual}.}
\item{fixed.effects}{input value of \code{fixed.effects}.}
\item{smm.ctr}{input value of \code{smm.ctr}.}
\item{details}{other details of the model.}
}
\description{
Summary and print methods for the class \code{smmSAR}.
}
