% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaveLoadPlp.R
\name{savePlpData}
\alias{savePlpData}
\title{Save the plpData to folder}
\usage{
savePlpData(plpData, file, envir = NULL, overwrite = FALSE)
}
\arguments{
\item{plpData}{An object of type \code{plpData} as generated using
\code{getPlpData}.}

\item{file}{The name of the folder where the data will be written. The folder should
not yet exist.}

\item{envir}{The environment for to evaluate variables when saving}

\item{overwrite}{Whether to force overwrite an existing file}
}
\value{
Called for its side effect, the data will be written to a set of files in the
folder specified by the user.
}
\description{
\code{savePlpData} saves an object of type plpData to folder.
}
\examples{
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 500, seed = 42)
saveLoc <- file.path(tempdir(), "savePlpData")
savePlpData(plpData, saveLoc)
dir(saveLoc, full.names = TRUE)

# clean up
unlink(saveLoc, recursive = TRUE)
}
