% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohortDiagnostics.R
\name{cohortDiagnostics}
\alias{cohortDiagnostics}
\title{Run cohort-level diagnostics}
\usage{
cohortDiagnostics(
  cohort,
  survival = FALSE,
  cohortSample = 20000,
  matchedSample = 1000
)
}
\arguments{
\item{cohort}{Cohort table in a cdm reference}

\item{survival}{TRUE or FALSE. Whether to conduct survival analysis (TRUE)
or not (FALSE).}

\item{cohortSample}{The number of people to take a random sample for cohortDiagnostics. If `cohortSample = NULL`, no sampling will be performed.}

\item{matchedSample}{The number of people to take a random sample for
matching. If `matchedSample = NULL`, no sampling will be performed. If `matchedSample = 0`, no
matched cohorts will be created.}
}
\value{
A summarised result
}
\description{
Runs phenotypeR diagnostics on the cohort.
The diganostics include:
* Age groups and sex summarised.
* A summary of visits of everyone in the cohort using visit_occurrence table.
* A summary of age and sex density of the cohort.
* Attritions of the cohorts.
* Overlap between cohorts (if more than one cohort is being used).
}
\examples{
\donttest{
library(omock)
library(CohortConstructor)
library(PhenotypeR)

cdm <- mockCdmFromDataset(source = "duckdb")
cdm$warfarin <- conceptCohort(cdm,
                              conceptSet =  list(warfarin = c(1310149L,
                                                              40163554L)),
                              name = "warfarin")

result <- cohortDiagnostics(cdm$warfarin)
}
}
