\name{first_order}
\alias{first_order}
\title{First order empirical model }
\usage{
first_order(M0, K1, t)
}
\arguments{
\item{M0}{Initial amount of drug released at t=0}
\item{K1}{First-order release rate constant)}
\item{t}{time}
}
\value{
Amount of drug released at time t Gallic Acid Equivalents per gram (GAE/gm)
}
\description{The first order empirical model signifies an exponential release profile consistent with Fickian mechanisms rather than a linear one.

Principle:

It is based on the principle that the release rate is directly proportional to the concentration of polyphenol remaining within the film matrix. The migration occurs rapidly at the beginning—when the concentration gradient between the film and the surrounding medium is high—and gradually decreases over time as the active compound becomes depleted (Ramos et al., 2014; Malekjani et al., 2024).

}
\examples{
 first_order (0.80, 0.025, 24)
}
\references{
Ramos, M., Beltrán, A., Peltzer, M., Valente, A. J., & del Carmen Garrigós, M. (2014). Release and antioxidant activity of carvacrol and thymol from polypropylene active packaging films. LWT-Food Science and Technology, 58(2), 470-477.

Malekjani, N., Karimi, R., Assadpour, E., & Jafari, S. M. (2024). Control of release in active packaging/coating for food products; approaches, mechanisms, profiles, and modeling. Critical reviews in food science and nutrition, 64(29), 10789-10811.
}
\keyword{first order emperical model}
