\name{zero_order}
\alias{zero_order}
\title{Zero order empirical model }
\usage{
zero_order(M0, K0, t)
}
\arguments{
\item{M0}{Initial amount of drug released at t=0}
\item{K0}{Zero-order release rate constant (the constant rate at which the drug is released, typically expressed in units like mg/hour)}
\item{t}{time}
}
\value{
Amount of drug released at time t Gallic Acid Equivalents per gram (GAE/gm)
}
\description{The zero-order empirical model signifies that polyphenol migration from the active packaging film occurs at a constant, concentration-independent rate over time.

Principle:

the zero-order model release governed by a constant rate (k0), independent of the remaining concentration of the active compound in the matrix resulting in a linear increase in the cumulative amount of migrated polyphenol with time. It indicates a predictable, sustained, and uniform delivery of polyphenol from the packaging film (Ramos et al., 2014; Malekjani et al., 2024).
}
\examples{
 zero_order(0.767, 0.0164, 72)
}
\references{
Ramos, M., Beltrán, A., Peltzer, M., Valente, A. J., & del Carmen Garrigós, M. (2014). Release and antioxidant activity of carvacrol and thymol from polypropylene active packaging films. LWT-Food Science and Technology, 58(2), 470-477.

Malekjani, N., Karimi, R., Assadpour, E., & Jafari, S. M. (2024). Control of release in active packaging/coating for food products; approaches, mechanisms, profiles, and modeling. Critical reviews in food science and nutrition, 64(29), 10789-10811.
}
\keyword{zero order emperical model}
