% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/technical_indicators.R
\name{calc_rolling_volatility}
\alias{calc_rolling_volatility}
\title{Calculate Rolling Volatility}
\usage{
calc_rolling_volatility(data, lookback = 20, method = "std")
}
\arguments{
\item{data}{Data frame with Date column and price columns}

\item{lookback}{Number of periods for rolling calculation (default: 20)}

\item{method}{Volatility calculation method: "std", "range", "mad", or "abs_return"}
}
\value{
Data frame with Date column and volatility values for each symbol
}
\description{
Calculates rolling volatility using various methods including standard deviation,
range-based, MAD, or absolute returns. Supports different lookback periods.
}
\examples{
data("sample_prices_weekly")
# Standard deviation volatility
vol <- calc_rolling_volatility(sample_prices_weekly, lookback = 20)
# Range-based volatility
vol_range <- calc_rolling_volatility(sample_prices_weekly, lookback = 20, method = "range")
}
