% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_adapters.R
\name{convert_to_nweeks}
\alias{convert_to_nweeks}
\title{Convert Data to N-Week Frequency}
\usage{
convert_to_nweeks(data, n = 1, method = "last")
}
\arguments{
\item{data}{Data.table with Date column and price columns}

\item{n}{Number of weeks to aggregate (default: 1 for weekly)}

\item{method}{Aggregation method: "last" or "mean" (default: "last")}
}
\value{
Data.table resampled to n-week frequency
}
\description{
Resamples daily or weekly data to n-week periods. Handles week-ending
calculations and various aggregation methods.
}
\examples{
data("sample_prices_daily")
# Convert daily to weekly
weekly <- convert_to_nweeks(sample_prices_daily, n = 1)
# Convert to bi-weekly
biweekly <- convert_to_nweeks(sample_prices_daily, n = 2)
}
