% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_helper.R
\name{ml_make_seq_model}
\alias{ml_make_seq_model}
\title{Deterministic sequence model factory (GRU/LSTM/CNN1D with linear fallback)}
\usage{
ml_make_seq_model(
  type = c("linear", "gru", "lstm", "cnn1d"),
  steps = 26L,
  units = 16L,
  dense = NULL,
  dropout = 0.1,
  epochs = 12L,
  batch_size = 128L,
  lr = 0.01,
  patience = 2L,
  seed = 123L,
  deterministic = TRUE,
  pred_batch_size = 256L
)
}
\arguments{
\item{type}{One of \code{"linear"}, \code{"gru"}, \code{"lstm"}, \code{"cnn1d"}.}

\item{steps}{Integer sequence length (e.g., 26 for 6 months of weeks).}

\item{units}{Hidden units for GRU/LSTM or filters for CNN1D.}

\item{dense}{Optional integer vector of additional dense layers.}

\item{dropout}{Dropout rate for recurrent/CNN core.}

\item{epochs, batch_size}{Training settings.}

\item{lr}{Learning rate.}

\item{patience}{Early-stopping patience.}

\item{seed}{Integer seed.}

\item{deterministic}{Logical; set determinism knobs when TRUE.}

\item{pred_batch_size}{Fixed batch size used at prediction time.}
}
\value{
A list with \verb{$fit} and \verb{$predict} closures.
}
\description{
Returns \code{fit/predict} closures for sequence models that consume flattened
tabular inputs (n \eqn{\times}{x} (steps \eqn{\times}{x} p)) and internally reshape to (n, steps, p).
If Keras/TensorFlow is unavailable, falls back to a linear baseline so
examples remain runnable on CPU-only machines.
}
\details{
Determinism knobs: fixed seeds, \code{TF_DETERMINISTIC_OPS=1}, no shuffle,
\code{workers=1}, and a fixed \code{pred_batch_size} to minimise retracing.

Optional dependencies: \code{keras} and \code{tensorflow}. When not available,
the factory returns the linear fallback.
}
\examples{
\dontrun{
seq_gru <- ml_make_seq_model("gru", steps = 26, units = 16, epochs = 12)
}
}
