% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.R
\name{select_top_k_scores_by_group}
\alias{select_top_k_scores_by_group}
\title{Select top-k symbols per group by score}
\usage{
select_top_k_scores_by_group(scores, k, group_map, max_per_group = 3L)
}
\arguments{
\item{scores}{Wide score panel (\code{Date} + symbols).}

\item{k}{Positive integer: number of symbols to select per group.}

\item{group_map}{Named character vector or 2-column data.frame
(\code{symbol}, \code{group}) mapping symbols to groups.}

\item{max_per_group}{Integer cap per group (default \code{3L}).}
}
\value{
Logical selection panel (\code{Date} + symbols) where \code{TRUE} marks
selected symbols.
}
\description{
For each date, choose the top \code{k} symbols \strong{within each group} based on a
score panel. Returns a logical selection panel aligned to the input.
}
\details{
\itemize{
\item Group membership comes from \code{group_map} (symbol -> group).
\item Selection is computed independently by group on each date.
\item Ties follow the ordering implied by \code{order(..., method = "radix")}.
}
}
\examples{
set.seed(42)
scores <- data.frame(
  Date = as.Date("2020-01-01") + 0:1,
  A = runif(2), B = runif(2), C = runif(2), D = runif(2), E = runif(2), F = runif(2)
)
gmap <- data.frame(Symbol = c("A","B","C","D","E","F"),
                   Group  = c("G1","G1","G2","G2","G3","G3"))
sel <- select_top_k_scores_by_group(scores, k = 4, group_map = gmap, max_per_group = 2)
head(sel)
}
