% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighting.R
\name{weight_by_signal}
\alias{weight_by_signal}
\title{Signal-Based Portfolio Weighting}
\usage{
weight_by_signal(selected_df, signal_df)
}
\arguments{
\item{selected_df}{Binary selection matrix}

\item{signal_df}{Signal values for weighting}
}
\value{
Data.table with signal-proportional weights
}
\description{
Weights selected securities proportionally to their signal strength.
Stronger signals receive higher allocations.
}
\examples{
data("sample_prices_weekly")
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
selected <- filter_top_n(momentum, 10)
# Weight by momentum strength
weights <- weight_by_signal(selected, momentum)
}
