% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoFAST.R
\name{NCFM_fast}
\alias{NCFM_fast}
\title{Cell-feature coembedding for SRT data}
\usage{
NCFM_fast(
  object,
  Adj_sp,
  assay = NULL,
  slot = "data",
  nfeatures = 2000,
  q = 10,
  reduction.name = "fast",
  var.features = NULL,
  ...
)
}
\arguments{
\item{object}{a Seurat object.}

\item{Adj_sp}{a sparse matrix, specify the adjacency matrix among spots.}

\item{assay}{an optional string, the name of assay used.}

\item{slot}{an optional string, the name of slot used.}

\item{nfeatures}{an optional postive integer, the number of features to select as top variable features. Default is 2000.}

\item{q}{an optional positive integer, specify the dimension of low dimensional embeddings to compute and store. Default is 10.}

\item{reduction.name}{an optional string, dimensional reduction name, `fast` by default.}

\item{var.features}{an optional string vector, specify the variable features, used to calculate cell embedding.}

\item{...}{Other argument passed  to the \code{\link{FAST_run}}.}
}
\description{
Run cell-feature coembedding for SRT data based on FAST model.
}
\examples{
data(CosMx_subset)
pos <- as.matrix(CosMx_subset@meta.data[,c("x", "y")])
Adj_sp <- AddAdj(pos)
# Here, we set maxIter = 3 for fast computation and demonstration.
CosMx_subset <- NCFM_fast(CosMx_subset, Adj_sp = Adj_sp, maxIter=3)

}
