% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_remove_blinks.R
\name{detect_blinks_by_column}
\alias{detect_blinks_by_column}
\title{detect blinks by a pre-existing labelled blink column that comes from the eyetracker}
\usage{
detect_blinks_by_column(
  data,
  pupil,
  column,
  extend_forward = 0,
  extend_back = 0,
  .tag = 1
)
}
\arguments{
\item{data}{dataset of class PupillometryR}

\item{pupil}{column name for pupil data}

\item{column}{column that refers to blinks}

\item{extend_forward}{number of observations to remove forward of blink}

\item{extend_back}{number of obervations to remove behind blink}

\item{.tag}{the variable in the blink column that represents a blink}
}
\value{
returns dataframe with blinks removed including forward and back, and data in blink column.
}
\description{
This allows the user to remove anything classed as a blink as a result of eyetracker output.
}
\examples{
\dontrun{
Sdata <- make_pupillometryr_data(data = pupil_data,
subject = ID,
trial = Trial,
time = Time,
condition = Type)

Sdata2 <- detect_blinks_by_column(data = Sdata,
pupil = LPupil,
column = data_in_blink,
extend_forward = 0,
extend_back = 0)
}

}
