% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_data.R
\name{get_api_data}
\alias{get_api_data}
\alias{get_api_data_1}
\alias{get_api_data_2}
\alias{get_api_data_12}
\title{PX-Web Data by API (GET)}
\usage{
get_api_data(
  url,
  return_dataset = NULL,
  make_na_status = TRUE,
  verbose_print = FALSE,
  use_ensure_json_stat2 = "auto"
)

get_api_data_1(..., return_dataset = 1)

get_api_data_2(..., return_dataset = 2)

get_api_data_12(..., return_dataset = 12)
}
\arguments{
\item{url}{A PxWeb API URL to data.}

\item{return_dataset}{Possible non-NULL values are \code{1}, \code{2} and \code{12}. Then a single data set is returned as a data frame.}

\item{make_na_status}{When TRUE and when dataPackage is \code{"rjstat"} and when missing entries in \code{value},
the function tries to add an additional variable, named \code{NAstatus}, with status codes.
An explanation of these status codes is provided in the note part of the comment attribute,
i.e. what you get with \code{\link[=note]{note()}}. See the bottom example.}

\item{verbose_print}{When TRUE, printing to console}

\item{use_ensure_json_stat2}{\code{TRUE}, \code{FALSE}, or \code{"auto"} (default).
If \code{"auto"}, the URL is modified by
\code{ensure_json_stat2()} only when \code{"/v2/"} is detected in the URL.}

\item{...}{Additional arguments passed to \code{\link[=get_api_data]{get_api_data()}}.}
}
\value{
A data frame, or a list of data frames, depending on the input and
parameters.
}
\description{
A function to read PX-Web data into R via API using GET.
}
\examples{
url <- paste0(
  "https://data.ssb.no/api/pxwebapi/v2/tables/03013/data?lang=en",
  "&valueCodes[Konsumgrp]=??",
  "&valueCodes[ContentsCode]=KpiIndMnd",
  "&valueCodes[Tid]=top(2)"
)
  
get_api_data_2(url)    
  
}
