% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LOD.QTLdetect.R
\name{LOD.QTLdetect}
\alias{LOD.QTLdetect}
\title{QTL Detect by LOD}
\usage{
LOD.QTLdetect(LOD, bin, thre = 3, QTLdist = 20, console = interactive())
}
\arguments{
\item{LOD}{matrix. The LOD matrix, which is a t*p matrix, where t is
the number of traits and p is the number of bins on the chromosomes.
Missing values should be denoted as NA in the matrix.}

\item{bin}{matrix. An n*2 matrix that represents the number of bins on
each chromosome, where n is the number of chromosomes. The first column
denotes the chromosome number, and the second column denotes the number
of bins on that chromosome. It's important to ensure that chromosomes
are divided in order.}

\item{thre}{numeric. The LOD threshold. Any LOD score under this
threshold will be calculated as 0.}

\item{QTLdist}{numeric. The minimum distance (in bins) among different
linked significant QTL.}

\item{console}{logical. Determines whether the process of the algorithm
will be displayed in the R console or not.}
}
\value{
\item{detect.QTL.number}{The number of detected QTL in each trait.}
\item{QTL.matrix}{The QTL position matrix. Where the elements 1
donates the position of QTL; elements 0 donate the bins whose LOD
score is under the LOD threshold; other positions are shown as NA.}
\item{EQF.matrix}{The matrix denotes the EQF value of each bin.}
\item{linkage.QTL.number}{The linkage QTL number of all detected
QTL. In other words, it is the table that denote how many QTL are
on one chromosome.}
\item{LOD.threshold}{The LOD threshold used in this analysis.}
\item{bin}{The bin information matrix used in this analysis.}
}
\description{
Detect QTL by the likelihood of odds (LOD) matrix.
}
\examples{
# load the example data
load(system.file("extdata", "LODexample.RDATA", package = "QTLEMM"))
dim(LODexample) # 100 traits, 633 bins on chromosome

# run and result
result <- LOD.QTLdetect(LODexample, bin, thre = 3, QTLdist = 10)
result$detect.QTL.number

}
\references{
Wu, P.-Y., M.-.H. Yang, and C.-H. KAO 2021 A Statistical Framework
for QTL Hotspot Detection. G3: Genes, Genomes, Genetics: jkab056. <doi: 10.1093/g3journal/jkab056>
}
\seealso{
\code{\link[QTLEMM]{EQF.permu}}
\code{\link[QTLEMM]{EQF.plot}}
}
