% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotReliability.R
\name{plotReliability}
\alias{plotReliability}
\title{Plot distributions of reliability estimates across entities}
\usage{
plotReliability(rel.out)
}
\arguments{
\item{rel.out}{results from \code{calcReliability()}}
}
\value{
A ggplot figure
}
\description{
This function creates boxplots of reliability estimates across entities and different methods
}
\examples{
### Simulate data with binary outcome
df <- simulateData(n.entity = 50, n.obs = 100, mu = .2, r = .7)

# Calculate reliability
out <- calcReliability(df = df, entity = 'entity', y = 'y', ctrRel = controlRel(n.resamples = 10))

# Plot estimates
plotReliability(out)


}
\author{
Kenneth Nieser (nieser@stanford.edu)
}
