## QuantRegGLasso: Adaptively Weighted Group Lasso for Semiparametric Quantile Regression Models

[![R build status](https://github.com/egpivo/QuantRegGLasso/workflows/R-CMD-check/badge.svg)](https://github.com/egpivo/QuantRegGLasso/actions)
[![Code Coverage](https://img.shields.io/codecov/c/github/egpivo/QuantRegGLasso/master.svg)](https://app.codecov.io/github/egpivo/QuantRegGLasso?branch=master)
[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version/QuantRegGLasso?color=green)](https://cran.r-project.org/package=QuantRegGLasso)
[![Downloads (monthly)](https://cranlogs.r-pkg.org/badges/QuantRegGLasso?color=brightgreen)](https://www.r-pkg.org/pkg/QuantRegGLasso)
[![Downloads (total)](https://cranlogs.r-pkg.org/badges/grand-total/QuantRegGLasso?color=brightgreen)](https://www.r-pkg.org/pkg/QuantRegGLasso)
[![BEJ](https://img.shields.io/badge/Bernoulli-10.3150%2FBEJ1091-brightgreen)](https://doi.org/10.3150/18-BEJ1091)


**QuantRegGLasso** is an R package designed for adaptively weighted group Lasso procedures in quantile regression. It excels in simultaneous variable selection and structure identification for varying coefficient quantile regression models and additive quantile regression models with ultra-high dimensional covariates.


### Installation
You can install **QuantRegGLasso** using either of the following methods:

#### Install from CRAN
```r
install.packages("QuantRegGLasso")
```

#### Install the Development Version from GitHub
```r
remotes::install_github("egpivo/QuantRegGLasso")
```

**Please Note:**

- **Windows Users:** Ensure that you have [Rtools](https://cran.r-project.org/bin/windows/Rtools/) installed before proceeding with the installation.

- **Mac Users:** You need Xcode Command Line Tools and should install the library [`gfortran`](https://github.com/fxcoudert/gfortran-for-macOS/releases). Follow these steps in the terminal:
  ```bash
  brew update
  brew install gcc
  ```

For a detailed solution, refer to this [link](https://blog.thecoatlessprofessor.com/programming/rcpp-rcpparmadillo-and-os-x-mavericks-lgfortran-and-lquadmath-error/index.html), or download and install the library [`gfortran`](https://github.com/fxcoudert/gfortran-for-macOS/releases) to resolve the "`ld: library not found for -lgfortran`" error.


### Authors
- [Wen-Ting Wang](https://www.linkedin.com/in/wen-ting-wang-6083a17b) ([GitHub](https://github.com/egpivo))
- [Wei-Ying Wu](https://projecteuclid.org/search?author=Wei-Ying_Wu)
- [Toshio Honda](https://www1.econ.hit-u.ac.jp/honda/e-honda.html)
- [Ching-Kang Ing](https://www.researchgate.net/profile/Ching-Kang-Ing)

 
### Maintainer
[Wen-Ting Wang](https://www.linkedin.com/in/wen-ting-wang-6083a17b) ([GitHub](https://github.com/egpivo))

### Reference
Toshio Honda, Ching-Kang Ing, Wei-Ying Wu (2019). [Adaptively weighted group Lasso for semiparametric quantile regression models](https://projecteuclid.org/journals/bernoulli/volume-25/issue-4B/Adaptively-weighted-group-Lasso-for-semiparametric-quantile-regression-models/10.3150/18-BEJ1091.full).

This paper introduces the adaptively weighted group Lasso procedure and its application to semiparametric quantile regression models. The methodology is grounded in a strong sparsity condition, establishing selection consistency under certain weight conditions.

## License
GPL (>= 2)


## Citation
- To cite package ‘QuantRegGLasso’ in publications use:
```
  Wang W, Wu W, Honda T, Ing C (2025). _QuantRegGLasso: Adaptively
  Weighted Group Lasso for Semiparametric Quantile Regression Models_.
  R package version 1.0.1,
  <https://CRAN.R-project.org/package=QuantRegGLasso>.
```

- A BibTeX entry for LaTeX users is
```
  @Manual{,
    title = {QuantRegGLasso: Adaptively Weighted Group Lasso for Semiparametric Quantile
Regression Models},
    author = {Wen-Ting Wang and Wei-Ying Wu and Toshio Honda and Ching-Kang Ing},
    year = {2025},
    note = {R package version 1.0.1},
    url = {https://CRAN.R-project.org/package=QuantRegGLasso},
  }
```
