% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap-project.R
\docType{class}
\name{redcap_project}
\alias{redcap_project}
\title{A Reference Class to make later calls to REDCap more convenient}
\description{
This \verb{Reference Class} represents a REDCap project.
Once some values are set that are specific to a REDCap project
(such as the URI and token), later calls are less verbose
(such as reading and writing data).
}
\section{Fields}{

\describe{
\item{\code{redcap_uri}}{The URI (uniform resource identifier) of the
REDCap project.  Required.}

\item{\code{token}}{token The user-specific string that serves as the
password for a project.  Required.}
}}

\section{Methods}{

\describe{
\item{\code{read(
  batch_size = 100L,
  interbatch_delay = 0,
  records = NULL,
  fields = NULL,
  forms = NULL,
  events = NULL,
  raw_or_label = "raw",
  raw_or_label_headers = "raw",
  export_checkbox_label = FALSE,
  export_survey_fields = FALSE,
  export_data_access_groups = FALSE,
  filter_logic = "",
  col_types = NULL,
  guess_type = TRUE,
  guess_max = 1000,
  verbose = TRUE,
  config_options = NULL
)}}{Exports records from a REDCap project.}

\item{\code{write(
  ds_to_write,
  batch_size = 100L,
  interbatch_delay = 0,
  continue_on_error = FALSE,
  verbose = TRUE,
  config_options = NULL
)}}{Imports records to a REDCap project.}
}}

\examples{
\dontrun{
uri     <- "https://redcap-dev-2.ouhsc.edu/redcap/api/"
token   <- "9A068C425B1341D69E83064A2D273A70"

project <- REDCapR::redcap_project$new(redcap_uri=uri, token=token)
ds_all  <- project$read()

# Demonstrate how repeated calls are more concise when the token and
#   url aren't always passed.
ds_skinny <- project$read(fields=c("record_id", "sex", "height"))$data

ids_of_males    <- ds_skinny$record_id[ds_skinny$sex==1]
ids_of_shorties <- ds_skinny$record_id[ds_skinny$height < 40]

ds_males        <- project$read(records=ids_of_males, batch_size=2)$data
ds_shorties     <- project$read(records=ids_of_shorties)$data

}
if (FALSE) {
# Switch the Genders
sex_original   <- ds_skinny$sex
ds_skinny$sex  <- (1 - ds_skinny$sex)
project$write(ds_skinny)

# Switch the Genders back
ds_skinny$sex <- sex_original
project$write(ds_skinny)
}
}
